#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int N;
    cin >> N;
    
    vector<int> A(N), B(N);
    
    for (int i = 0; i < N; i++) {
        cin >> A[i];
    }
    
    for (int i = 0; i < N; i++) {
        cin >> B[i];
    }
    
    int max_value = 0;
    
    // O( N^2 ) approach to check all subarrays
    for (int L = 0; L < N; L++) {
        int xor_value = 0;
        int and_value = B[L];
        
        for (int R = L; R < N; R++) {
            xor_value ^= A[R];
            and_value &= B[R];
            
            // Calculate the value of the subarray
            int value = xor_value * and_value;
            max_value = max(max_value, value);
        }
    }
    
    cout << max_value << endl;
    
    return 0;
}